//Program to design a Butterworth Low pass filter to Band limit a sine wave up to 4kHz . Taking the input as a ‘tone’ .
// Version : Scilab 5.2.2
// Operating Syatem : Ubuntu 16.04 LTS
clc; 
clear;
xdel(winsid());
Fc =4000;                                   // Cut-off frequency
Fs =44100;                                  // Sampling frequency
N =8 ;                                      // Order
Fp = 2*Fc/Fs;                               //Pass band edge frequency 
[Hz]=iir(N,'lp','butt',[Fp/2,0],[0,0])
[p,z,g]=iir(N,'lp','butt',[Fp/2,0],[0,0])   // digital IIR Butterworth Filter 
[Hw,w] = frmag(Hz ,256);

// Plotting the filter design
figure(1)
plot(2*w,abs(Hw)); 
xlabel("Digital Frequency  Normalized (w)")
ylabel("Magnitude")
title("Magnitude Response of Butterworth filter ")
xgrid(1)

[y,Fs]=wavread("tone1k.wav")                 // Reading the y
figure(2)
subplot(2,1,1)
plot(y)
title('Input signal waveform before filtering');
xlabel('Frequency');
ylabel('Magnitude');
playsnd(y)
L=length(y)

outlow=filter(z,abs(p),y);
subplot(2,1,2)
plot(outlow)
title('Output signal waveform after filtering')
xlabel('Frequency');
ylabel('Magnitude');

playsnd(outlow)

Da = fft(y,-1); 
Pyy = (1/L)*(abs(Da).^2); //Peridogram Estimate 


 
